<?php
date_default_timezone_set('America/Sao_Paulo'); // Define o fuso horário para Divinópolis-MG (Brasília)

$hora = date("H"); // Obtém a hora no formato 24h (00-23)
$minutos = date("i"); // Obtém os minutos
$periodo = ($hora < 12) ? "am" : "pm"; // Define AM ou PM

$data_formatada = date("d/m"); // Formata a data como DD/MM

// Saudação dinâmica
$usuario = "João"; // Depois será substituído pela sessão

if ($hora >= 6 && $hora < 12) {
    $saudacao = "Bom dia, $usuario!";
    $icone = '<i class="fi fi-rr-brightness"></i>';
} elseif ($hora >= 12 && $hora < 18) {
    $saudacao = "Boa tarde, $usuario!";
    $icone = '<i class="fi fi-rr-sunset"></i>';
} else {
    $saudacao = "Boa noite, $usuario!";
    $icone = '<i class="fi fi-rr-moon-stars"></i>';
}

// Definir dia da semana em português
$dias_semana = [
    'Sunday'    => 'Domingo',
    'Monday'    => 'Segunda-feira',
    'Tuesday'   => 'Terça-feira',
    'Wednesday' => 'Quarta-feira',
    'Thursday'  => 'Quinta-feira',
    'Friday'    => 'Sexta-feira',
    'Saturday'  => 'Sábado'
];

$dia_semana = $dias_semana[date("l")]; // Obtém o nome do dia atual
?>

<!doctype html>
<html lang="pt-BR">

<head>
    <title>Side Nav</title>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="reset.css">
    <link rel="stylesheet" href="nav-lateral.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css" integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="uicons-regular-rounded/css/uicons-regular-rounded.css">
</head>

<body>

    <section class="main-conteiner" id="sidebar">
        <div class="profile-pic">
            <img src="profile-pic.jpg" alt="" class="photo">
        </div>
        <div class="saudation">
            <?= $icone ?> <span><?= $saudacao ?></span>
        </div>
        <div class="week-day">
            <p>Hoje é <strong><?= $dia_semana ?></strong></p>
        </div>
        <div class="hours">
            <div class="hour-clock"><i class="fi fi-rr-clock-nine"></i> <span class="time"><?= $hora ?>:<?= $minutos ?> <?= $periodo ?></span></div>
            <div class="calendar"> <i class="fi fi-rr-calendar"></i> <?= $data_formatada ?></div>

        </div>
        <div class="rule">
            <img src="Line-6.svg" alt="" srcset="">
        </div>
        <div class="alteraaqui">
            <ul class="nav flex-column">
                <!-- Item 1 -->
                <li class="nav-item">
                    <a class="nav-link" href="#">
                        <i class="fi fi-rr-house-chimney"></i> Home
                    </a>
                </li>


                <!-- Item 2 -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="menu2" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="fi fi-rr-user"></i> Perfil e Configurações
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="menu2">
                        <li><a class="dropdown-item" href="#"><i class="fi fi-rr-user"></i> Meu Perfil</a></li>
                        <li><a class="dropdown-item" href="#"><i class="fi fi-rr-settings"></i> Configurações</a></li>
                        <li><a class="dropdown-item" href="#"><i class="fi fi-rr-fingerprint"></i> Segurança e Privacidade</a></li>
                        <li><a class="dropdown-item" href="#"><i class="fi fi-rr-folder-open"></i> Meus Documentos</a></li>
                    </ul>
                </li>

                <!-- Item 3 -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="menu3" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="fi fi-rr-trophy-star"></i> Rewards
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="menu3">
                        <li><a class="dropdown-item" href="#"><i class="fi fi-rr-medal"></i> Conquistas</a></li>
                        <li><a class="dropdown-item" href="#"><i class="fi fi-rr-list-check"></i> Missões</a></li>
                        <li><a class="dropdown-item" href="#"><i class="fi fi-rr-user-fast-running"></i> Menco em Movimento</a></li>
                        <li><a class="dropdown-item" href="#"><i class="fi fi-rr-snap"></i> Indicação Premiada</a></li>
                        <li><a class="dropdown-item" href="#"><i class="fi fi-rr-time-past"></i> Histórico Premiações</a></li>
                    </ul>
                </li>

                <!-- Item 4 -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="menu3" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="fi fi-rr-book-bookmark"></i> Agenda
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="menu3">
                        <li><a class="dropdown-item" href="#"><i class="fi fi-rr-address-book"></i> Minha Agenda</a></li>
                        <li><a class="dropdown-item" href="#"><i class="fi fi-rr-glass-cheers"></i> Eventos Futuros</a></li>
                        <li><a class="dropdown-item" href="#"><i class="fi fi-rr-lesson-class"></i> Treinamentos e Workshops</a></li>
                        <li><a class="dropdown-item" href="#"><i class="fi fi-rr-street-view"></i> Minhas Atividades</a></li>
                        <li><a class="dropdown-item" href="#"><i class="fi fi-rr-challenge"></i> Calendário de Desafios</a></li>
                        <li><a class="dropdown-item" href="#"><i class="fi fi-rr-notes"></i> Lembretes e Notificações</a></li>
                        <li><a class="dropdown-item" href="#"><i class="fi fi-rr-meeting"></i> Reuniões e Palestras</a></li>
                        <li><a class="dropdown-item" href="#"><i class="fi fi-rr-stats"></i> Fechamento de Resultados</a></li>
                        <li><a class="dropdown-item" href="#"><i class="fi fi-rr-megaphone"></i> Cronograma de Campanhas</a></li>
                    </ul>
                </li>

                <!-- Item 4 -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="menu3" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="fi fi-rr-megaphone"></i> Comunicação Interna
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="menu3">
                        <li><a class="dropdown-item" href="#"><i class="fi fi-rr-megaphone-announcement-leader"></i> Comunicados Internos</a></li>
                        <li><a class="dropdown-item" href="#"><i class="fi fi-rr-phone-call"></i> Contatos Úteis</a></li>
                        <li><a class="dropdown-item" href="#"><i class="fi fi-rr-book-bookmark"></i> Central de Ajuda</a></li>
                    </ul>
                </li>
            </ul>
        </div>

    </section>
    <button class="toggle-btn" id="toggleSidebar"><i class="fi fi-rr-arrow-small-left"></i></button>

    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.min.js"></script>

    <script>
        function atualizarRelogio() {
            const agora = new Date();
            let horas = agora.getHours();
            let minutos = agora.getMinutes();
            let periodo = horas < 12 ? "am" : "pm";

            // Formatar para dois dígitos (ex: 08:09 em vez de 8:9)
            horas = horas.toString().padStart(2, '0');
            minutos = minutos.toString().padStart(2, '0');

            // Atualizar o horário na página
            document.querySelector(".time").innerHTML = `${horas}:${minutos} ${periodo}`;
        }

        // Atualiza o relógio a cada segundo
        setInterval(atualizarRelogio, 1000);

        // Chama a função imediatamente para não precisar esperar o primeiro segundo
        atualizarRelogio();
    </script>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const toggleBtn = document.getElementById("toggleSidebar");
            const sidebar = document.getElementById("sidebar");

            toggleBtn.addEventListener("click", function() {
                sidebar.classList.toggle("hidden");

                // Altera o ícone do botão dependendo do estado do menu
                toggleBtn.innerHTML = sidebar.classList.contains("hidden") ?
                    '<i class="fi fi-rr-arrow-small-right"></i>' :
                    '<i class="fi fi-rr-arrow-small-left"></i>';

            });
        });
    </script>



</body>

</html>